%% thesisclass.cls
%% LaTeX2e class for diploma theses
%% Based on wissdoc.cls by Roland Bless, 1996-2001
%% bless@telematik.informatik.uni-karlsruhe.de
%%
%% Adapted by: Timo Rohrberg, 2009
%% timo.rohrberg@student.kit.edu
%%
%% Additions by: Thorsten Haberecht, IPD - Chair Prof. B�hm, 2010
%% thorsten.haberecht@kit.edu
%% 


\NeedsTeXFormat{LaTeX2e} % We do need LaTeX2e
\ProvidesClass{thesisclass}
\LoadClass[a4paper,11pt,titlepage,openany]{scrbook} % Class based on scrbook

%% -------------------------------
%% |          Packages           |
%% -------------------------------

\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc} % Input in UTF-8
\usepackage{ae} % Almost european, virtual T1-Font

\usepackage[pdftex]{graphicx}
\usepackage{vmargin} % Adjust margins in a simple way
\usepackage[automark]{scrlayer-scrpage} % Replace fancyhdr with scrlayer-scrpage

\usepackage{subfig}
\usepackage{url}
\usepackage[absolute,overlay]{textpos}
\usepackage{tikz}
%\usepackage{algorithm} % Code-Listings
%\usepackage{algorithmic} % Code-Listings
\usepackage{setspace} % 1.5 line spacing
\usepackage[
    raiselinks=true,
    bookmarks=true,
    bookmarksopenlevel=1,
    bookmarksopen=true,
    bookmarksnumbered=true,
    hyperindex=true,
    plainpages=false,
    pdfpagelabels=true,
    colorlinks=true,         % activate colored text instead of boxes
    linkcolor=black,           % color for internal links (e.g., \ref)
    citecolor=blue,          % color for citations (e.g., \cite)
    urlcolor=green           % color for \url and \href
]{hyperref}


\onehalfspacing

%% --- End of Packages ---

%% -------------------------------
%% |        Declarations         |
%% -------------------------------
\DeclareGraphicsExtensions{.svg}
%% --- End of Declarations ---

%% -------------------------------
%% |         New commands        |
%% -------------------------------
\newcommand{\changefont}[3]{\fontfamily{#1} \fontseries{#2} \fontshape{#3} \selectfont}
%\renewcommand*{\headfont}{\slshape}
%\newcommand{\captionfont}{}
\newcommand{\chapterheadfont}{}
\newcommand{\blankpage}{
 \clearpage{\pagestyle{empty}\cleardoublepage}
}
%% --- End of New Commands ---

%% -------------------------------
%% |      Globale Settings       |
%% -------------------------------
\setcounter{secnumdepth}{3} % Numbering also for \subsubsections
\setcounter{tocdepth}{3} % Register \subsubsections in content directory

\setpapersize{A4}
\setmarginsrb{3cm}{1cm}{3cm}{1cm}{6mm}{7mm}{5mm}{15mm}

\parindent 0cm % Do not indent beginning of paragraph
\parskip 1.5ex plus0.5ex minus0.5ex % Margin between paragraphs

\KOMAoptions{footheight=16.5pt, headheight=20.4pt} % Adjusting head and foot height, and headsepline
%% --- End of global Settings ---


\pagestyle{scrheadings}

% Define header and footer content
\clearpairofpagestyles
\ihead{} % Clear inner header (left side)
\chead{} % Clear center header
\ohead{\pagemark} % Outer header (right side) contains the page number

\KOMAoptions{headsepline=0.5pt:1\textwidth} % Example to set headsepline thickness and length


% Configure the footer: Page number centered at the bottom
\ifoot{} % Clear inner footer (left side)
\cfoot{\pagemark} % Center footer contains the page number
\ofoot{} % Clear outer footer (right side)

% Custom chapter and section marks
\renewcommand{\chaptermark}[1]{\markboth{\thechapter.\ #1}{}}
\renewcommand{\sectionmark}[1]{\markright{\thesection\ #1}}
%% --- End of Headings ---

%% -------------------------------
%% |      Style of captions      |
%% -------------------------------
\renewcommand{\chaptername}{}

\renewcommand{\section}{%
\@startsection{section}%
{1} % Structure level
{0mm} % Indention
{2ex plus 1ex minus 1ex} % Pre-Margin
{0.5ex plus 0.5ex minus 0.5ex} % Post-Margin
{\chapterheadfont\Large\bfseries} % Style
}
\renewcommand{\subsection}{%
\@startsection{subsection}%
{2} % Structure level
{0mm} % Indention
{1.5ex plus 1ex minus 0.5ex} % Pre-Margin
{0.3ex plus 0.3ex minus 0.3ex} % Post-Margin
{\chapterheadfont\large\bfseries} % Style
}
\renewcommand{\subsubsection}{%
\@startsection{subsubsection}%
{3} % Structure level
{0mm} % Indention
{1.5ex plus 1ex minus 0.5ex} % Pre-Margin
{0.2ex plus 0.2ex minus 0.2ex} % Post-Margin
{\chapterheadfont\normalsize\bfseries} % Style
}
\renewcommand{\paragraph}{%
\@startsection{paragraph}%
{4} % Structure level
{0mm} % Indention
{1.3ex plus 1ex minus 0.3ex} % Pre-Margin
{0.2ex plus 0.2ex minus 0.2ex} % Post-Margin
{\chapterheadfont\normalsize\bfseries} % Style
}
\renewcommand{\subparagraph}{%
\@startsection{subparagraph}%
{5} % Structure level
{0mm} % Indention
{1ex plus 1ex minus 0.2ex} % Pre-Margin
{0.1ex plus 0.1ex minus 0.1ex} % Post-Margin
{\chapterheadfont\normalsize\bfseries} % Style
}
%% --- End of captions style ---

%% ---------------------------------
%% |   Style of chapter captions   |
%% ---------------------------------
\newlength{\chapnolen}
\newlength{\chapparlen}
\newsavebox{\chapno}
\renewcommand{\@makechapterhead}[1]{
  %\vspace*{0.2\textheight}
  %\vskip 15\p@
  {\parindent \z@ \raggedright \normalfont
    \ifnum \c@secnumdepth >\m@ne
      \if@mainmatter
        \savebox{\chapno}{\chapterheadfont\huge\bfseries \thechapter.}
        \settowidth{\chapnolen}{\usebox{\chapno}}
        \parbox[t]{\chapnolen}{\usebox{\chapno}}\nobreak\leavevmode
      \fi
    \fi
    \interlinepenalty\@MM
    \setlength{\chapparlen}{\textwidth}
    \addtolength{\chapparlen}{-1.0\chapnolen}
    \addtolength{\chapparlen}{-2ex}
    \leavevmode\nobreak
    \parbox[t]{\chapparlen}{\raggedright\chapterheadfont\huge \bfseries #1\par\nobreak}
    \vskip 20\p@ % Adjusts spacing after Chapter Head
  }}

\renewcommand{\@makeschapterhead}[1]{
  \vspace*{50\p@}
  {\parindent \z@ \raggedright
    \normalfont
    \interlinepenalty\@M
    \chapterheadfont \huge \bfseries  #1\par\nobreak
    \vskip 40\p@
  }
}
%% --- End of chapter captions style ---

%% ---------------------------------
%% |  Style of content directory   |
%% ---------------------------------
\let\oldtableofcontents\tableofcontents
\renewcommand{\tableofcontents}{{\pdfbookmark{\contentsname}{\contentsname}\chapterheadfont\oldtableofcontents}}
% Remove tocloft related redefinitions
%\let\@olddottedtocline\@dottedtocline
%\renewcommand{\@dottedtocline}[5]{\@olddottedtocline{#1}{#2}{#3}{#4}{\chapterheadfont #5}}
%\renewcommand{\cftchapfont}{\normalfont\bfseries}
%\renewcommand{\cfttoctitlefont}{\huge\bfseries} % Corrects Table of Contents Chapter Head font
%\renewcommand{\cftloftitlefont}{\huge\bfseries} % Corrects List of Figures Chapter Head font
%\renewcommand{\cftlottitlefont}{\huge\bfseries} % Corrects List of Tables Chapter Head font
%% --- End of content directory style ---

%% ----------------------------------
%% |  Style of appendix numbering   |
%% ----------------------------------
%\renewcommand\appendix{\par 
%   \setcounter{section}{0}% 
 %  \setcounter{subsection}{0}% 
  % \setcounter{figure}{0}%
 %  \renewcommand\thesection{\Alph{section}}% 
  % \renewcommand\thefigure{\Alph{section}.\arabic{figure}} 
 %  \renewcommand\thetable{\Alph{section}.\arabic{table}}}
%% --- End of appendix numbering style ---

%% **** END OF CLASS ****
